/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.cim.provider.pi.PIClusterModifier;
import com.ibm.hsc.cim.provider.pi.PIHscCimObjUtils;
import com.ibm.hsc.cim.provider.pi.PIHscIProviderBase;
import com.ibm.hsc.cim.provider.pi.PIPartitionInstProvUtils;
import com.ibm.hsc.cim.provider.pi.PIResourcesAllocationUtils;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.exceptions.PISystemException;
import com.ibm.hsc.common.util.CmdExtendedError;
import com.ibm.hsc.common.util.CmdExtendedErrorList;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscPerformance;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspVspAttr;
import com.ibm.hsc.fsp.lockmgr.FspLockHelper;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.nvram.PIHMCSaveArea;
import com.ibm.hsc.rep.RException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;
import org.snia.wbemcfg.GlobalConfig;

public class PIPartitionInstProv
extends PIHscIProviderBase {
    private static final String CLASS_NAME = "PIPartitionInstProv";
    private static final String SEPERATOR = "****************************************";

    public Vector enumInstancesPathImpl(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws PIHscServerException, CIMException {
        return null;
    }

    public Vector associatorsImpl(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3, boolean bl, boolean bl2, String[] stringArray) throws PIHscServerException, CIMException {
        return null;
    }

    public Vector associatorNamesImpl(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3) throws PIHscServerException, CIMException {
        return null;
    }

    public Vector referencesImpl(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, boolean bl, boolean bl2, String[] stringArray) throws PIHscServerException, CIMException {
        return null;
    }

    public Vector referenceNamesImpl(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string) throws PIHscServerException, CIMException {
        return null;
    }

    public CIMObjectPath createInstanceImpl(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws PIHscServerException {
        throw new PIHscServerException("2520", null);
    }

    public static CIMObjectPath createPartition(ProviderCIMOMHandle providerCIMOMHandle, String string, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws PIHscServerException {
        String string2 = "";
        try {
            string2 = (String)cIMInstance.getProperty("Name").getValue().getValue();
        }
        catch (NullPointerException nullPointerException) {
            throw new PIHscServerException("2523", new String[]{"R50Partition.Name"}, nullPointerException);
        }
        int n = string2.indexOf(42);
        int n2 = Integer.parseInt(string2.substring(0, n));
        String string3 = string2.substring(n + 1);
        OmCecMgr omCecMgr = OmCecMgr.getCecMgr(string3);
        try {
            CIMInstance cIMInstance2;
            UnsignedInt8 unsignedInt8;
            Object object;
            if (1 <= Trace.LEVEL) {
                Trace.trace("aplphscT", "-> createInstance");
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace("aplphscF", "op =" + cIMObjectPath);
                Trace.trace("aplphscF", "ci = " + cIMInstance);
            }
            CIMObjectPath cIMObjectPath2 = null;
            CIMObjectPath cIMObjectPath3 = null;
            String string4 = null;
            Object var12_14 = null;
            String string5 = string;
            if (2 <= Trace.LEVEL) {
                Trace.trace("aplphscF", "cecName = " + string3);
            }
            FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
            try {
                int n3;
                int n4;
                block37: {
                    cIMObjectPath2 = new CIMObjectPath("IBMHSC_ComputerSystem", string5);
                    cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                    cIMObjectPath2.addKey("Name", new CIMValue((Object)string3));
                    object = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, providerCIMOMHandle.getClass(cIMObjectPath2, false), false);
                    try {
                        string4 = (String)cIMInstance.getProperty("UserDefinedName").getValue().getValue();
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new PIHscServerException("2523", new String[]{"R50Partition.UserDefinedName"}, nullPointerException);
                    }
                    PIPartitionInstProvUtils.checkCreatePrereq(object, cIMObjectPath, cIMInstance, omCecMgr);
                    CIMValue cIMValue = cIMInstance.getProperty("SharedPoolUtilizationAuthority").getValue();
                    unsignedInt8 = new UnsignedInt8(0);
                    if (cIMValue != null) {
                        unsignedInt8 = (UnsignedInt8)cIMValue.getValue();
                    }
                    cIMInstance2 = null;
                    boolean bl = false;
                    n4 = ((UnsignedInt8)cIMInstance.getProperty("DefinitionState").getValue().getValue()).intValue();
                    n2 = PIPartitionInstProvUtils.checkAndGetUndefLparForCreate(cIMObjectPath2, cIMObjectPath, cIMInstance, providerCIMOMHandle, omCecMgr);
                    try {
                        fspCmdHelper.setLparSlotDefinitionState(new UnsignedInt16(n2), new UnsignedInt8((short)n4));
                    }
                    catch (PISystemException pISystemException) {
                        CmdExtendedErrorList cmdExtendedErrorList;
                        CmdExtendedError[] cmdExtendedErrorArray;
                        n3 = 0;
                        if (pISystemException.isExtendedError() && (cmdExtendedErrorArray = (cmdExtendedErrorList = pISystemException.getExtendedError()).getErrorArray()) != null && cmdExtendedErrorArray.length > 0) {
                            byte[] byArray;
                            CmdExtendedError cmdExtendedError = cmdExtendedErrorArray[0];
                            long l = cmdExtendedError.extractErrorCode();
                            System.out.println("errCode = " + l + "\nPIHscConstants.PHYP_EXT_ERR_ERROR  |0xE002 = " + 1073799170L);
                            if (l == 1073799170L && (byArray = cmdExtendedError.getErrorParms()) != null && byArray.length > 0) {
                                UnsignedInt16 unsignedInt16 = null;
                                try {
                                    unsignedInt16 = (UnsignedInt16)object.getProperty("LMBSize").getValue().getValue();
                                }
                                catch (Throwable throwable) {
                                    throw new PIHscServerException("2523", new String[]{"R50ComputerSystem.LMBSize"}, throwable);
                                }
                                BigInteger bigInteger = new BigInteger(byArray);
                                System.out.println("memVal = " + bigInteger);
                                long l2 = PIResourcesAllocationUtils.getAdditionPhypMemNeeded(bigInteger.longValue() * unsignedInt16.longValue(), unsignedInt16.longValue(), fspCmdHelper);
                                PIPartitionInstProvUtils.stealMemForCreateLpar(l2, new UnsignedInt16(n2), string3, providerCIMOMHandle, string5, omCecMgr);
                                fspCmdHelper.setLparSlotDefinitionState(new UnsignedInt16(n2), new UnsignedInt8((short)n4));
                                n3 = 1;
                            }
                        }
                        if (n3 != 0) break block37;
                        throw pISystemException;
                    }
                }
                fspCmdHelper.setLparName(new UnsignedInt16(n2), string4);
                fspCmdHelper.setLparSharedPoolUtilizationAuthority(new UnsignedInt16(n2), unsignedInt8);
                PIHMCSaveArea pIHMCSaveArea = PIHMCSaveArea.getPIHMCSaveAreaInstance(string3);
                if (pIHMCSaveArea == null) {
                    throw new PIHscServerException("0005", null);
                }
                n3 = 0;
                if (n4 == 1) {
                    n3 = 1;
                } else if (n4 == 129) {
                    n3 = 129;
                } else if (n4 == 65) {
                    n3 = 4;
                } else if (n4 == 3) {
                    n3 = 65;
                } else {
                    throw new PIHscServerException("0601", null);
                }
                pIHMCSaveArea.setPartitionInfo(n2, string4, (byte)n3);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                throwable.printStackTrace();
                if (!(throwable instanceof PIHscServerException)) {
                    throw new PIHscServerException("05EB", null);
                }
                throw (PIHscServerException)throwable;
            }
            cIMInstance.setProperty("PartitionState", new CIMValue((Object)new UnsignedInt8(0), new CIMDataType(1)));
            object = n2 + "*" + string3;
            cIMInstance.setProperty("Name", new CIMValue(object));
            cIMObjectPath = new CIMObjectPath("IBMHSC_Partition", cIMInstance.getKeyValuePairs());
            cIMObjectPath.setNameSpace(string5);
            try {
                cIMObjectPath3 = PIPartitionInstProvUtils.updateCimRepoForCreate(cIMObjectPath2, cIMObjectPath, cIMInstance, providerCIMOMHandle);
                System.out.println("Creating the lpar manager for new partition " + (String)object);
                omCecMgr.addLparMgr(omCecMgr.createLparMgr((String)object));
                try {
                    omCecMgr.getIndMgr().sendIndication(1, cIMInstance, null);
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    throwable.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                try {
                    unsignedInt8 = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, providerCIMOMHandle.getClass(cIMObjectPath2, false), false);
                    cIMInstance2 = unsignedInt8.filterProperties(null, true, true);
                    cIMInstance2.setProperty("State", new CIMValue((Object)new UnsignedInt8(253)));
                    CimomWrapper.setInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath2, cIMInstance2);
                    try {
                        omCecMgr.getIndMgr().sendIndication(4, cIMInstance2, unsignedInt8);
                    }
                    catch (Throwable throwable2) {
                        HSCLogUtils.serverLog(throwable2, HSCLogUtils._LPARClassLogInfo);
                        throwable2.printStackTrace();
                    }
                }
                catch (Throwable throwable3) {
                    HSCLogUtils.serverLog(throwable3, HSCLogUtils._RestoreClassLogInfo);
                }
            }
            PIClusterModifier.changeCluster((CIMOMHandle)providerCIMOMHandle, cIMObjectPath3, (UnsignedInt16)null, omCecMgr, string);
            return cIMObjectPath3;
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("05EB", null);
            }
            throw (PIHscServerException)throwable;
        }
    }

    public void deleteInstanceImpl(CIMObjectPath cIMObjectPath) throws PIHscServerException {
        String string = null;
        int[] nArray = PIClusterModifier.checkWlmPolicy(4, (CIMOMHandle)this.m_CimomHandle, cIMObjectPath, null, -1);
        if (nArray[0] != 0) {
            System.err.println("WLM: do not allowed to delete " + cIMObjectPath);
            throw new PIHscServerException("0500");
        }
        try {
            string = this.getCecName(cIMObjectPath);
        }
        catch (CIMException cIMException) {
            throw new PIHscServerException("0200", cIMException);
        }
        OmCecMgr omCecMgr = OmCecMgr.getCecMgr(string);
        int n = 64;
        FspLockHelper fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n);
        try {
            fspLockHelper.addNvramLock(omCecMgr.getObjectId());
            fspLockHelper.addLparLock(cIMObjectPath);
            fspLockHelper.lock();
            PIPartitionInstProv.deletePartition(this.m_CimomHandle, cIMObjectPath, string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException(throwable.getMessage());
            }
            throw (PIHscServerException)throwable;
        }
        finally {
            fspLockHelper.unlock();
        }
    }

    public static void deletePartition(ProviderCIMOMHandle providerCIMOMHandle, CIMObjectPath cIMObjectPath, String string) throws PIHscServerException, PIHscCmdMgrException, RException {
        UnsignedInt16 unsignedInt16;
        CIMInstance cIMInstance;
        System.out.println("JPDelete:  Entering PIPartitionInstProv.deletePartition");
        OmCecMgr omCecMgr = OmCecMgr.getCecMgr(string);
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        PIPartitionInstProvUtils.checkTaskPrereqs(cIMObjectPath, providerCIMOMHandle, omCecMgr, string);
        try {
            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
            unsignedInt16 = PIPartitionInstProvUtils.getPartId(cIMInstance);
            short s = ((UnsignedInt8)cIMInstance.getProperty("DefinitionState").getValue().getValue()).shortValue();
            int n = 0;
            if (2 == s) {
                n = 1;
            } else if (4 == s) {
                n = 3;
            } else if (130 == s) {
                n = 129;
            } else if (66 == s) {
                n = 65;
            }
            fspCmdHelper.setLparSlotDefinitionState(unsignedInt16, new UnsignedInt8((short)n));
            Vector vector = null;
            try {
                vector = CimomWrapper.associators((CIMOMHandle)providerCIMOMHandle, new CIMObjectPath("IBMHSC_AllocatedSlot", "root/ibmhscS1_0"), cIMObjectPath, "IBMHSC_PCISlot", "GroupComponent", "PartComponent", false, false, null);
            }
            catch (CIMException cIMException) {
                vector = null;
            }
            if (vector != null && vector.size() > 0) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    CIMInstance cIMInstance2 = (CIMInstance)enumeration.nextElement();
                    UnsignedInt32 unsignedInt32 = new UnsignedInt32(Long.parseLong((String)cIMInstance2.getProperty("DeviceID").getValue().getValue()));
                    fspCmdHelper.setIoSlotOwnerAndPoolId(unsignedInt32, new UnsignedInt16(65535), new UnsignedInt16(65535), new UnsignedInt8(1));
                }
            }
        }
        catch (CIMException cIMException) {
            throw new PIHscServerException("05E0", cIMException);
        }
        fspCmdHelper.setLparSlotDefinitionState(unsignedInt16, new UnsignedInt8(0));
        String string2 = (String)cIMInstance.getProperty("Name").getValue().getValue();
        omCecMgr.deleteLpar(string2, true);
        System.out.print("JPDelete:  Exiting PIPartitionInstProv.deletePartition");
    }

    public Vector enumInstancesImpl(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        int n = HscPerformance.startTransaction("PIPartitionInstProv.enumInstancesImpl+ " + cIMObjectPath);
        try {
            Vector vector;
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("****************************************\nPIPartitionInstProv.enumInstances");
            }
            if (1 <= Trace.LEVEL) {
                Trace.trace("aplphscT", "-> PIPartitionInstProv.enumInstances");
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace("aplphscF", "op = " + cIMObjectPath + "  deep = " + bl + "  cc = " + cIMClass);
            }
            Vector vector2 = vector = CimomWrapper.enumInstances((CIMOMHandle)this.m_CimomHandle, cIMObjectPath, bl, cIMClass);
            return vector2;
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            throw new HSCCIMException(throwable);
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("aplphscT", "<- PIPartitionInstProv.enumInstances");
            }
        }
    }

    public Vector enumInstancesImpl(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        Vector vector;
        int n;
        int n2;
        block9: {
            n2 = HscPerformance.startTransaction("PIPartitionInstProv.enumInstancesImpl+" + cIMObjectPath);
            n = 0;
            try {
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("****************************************\nPIPartitionInstProv.enumInstances");
                }
                if (1 <= Trace.LEVEL) {
                    Trace.trace("aplphscT", "-> enumInstances");
                }
                if (2 <= Trace.LEVEL) {
                    Trace.trace("aplphscF", "op = " + cIMObjectPath + "  deep = " + bl + "  cc = " + cIMClass + "  localOnly = " + bl2);
                }
                Vector vector2 = CimomWrapper.enumInstances((CIMOMHandle)this.m_CimomHandle, cIMObjectPath, bl, cIMClass, bl2);
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("PIPartitionInstProv.enumInstances****************************************");
                }
                vector = vector2;
                Object var10_10 = null;
                if (1 > Trace.LEVEL) break block9;
            }
            catch (Throwable throwable) {
                try {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    n = 1;
                    throw new HSCCIMException(throwable);
                }
                catch (Throwable throwable2) {
                    Object var10_11 = null;
                    if (1 <= Trace.LEVEL) {
                        Trace.trace("aplphscT", "<- PIPartitionInstProv.enumInstance");
                    }
                    HscPerformance.endTransaction(n2, n);
                    throw throwable2;
                }
            }
            Trace.trace("aplphscT", "<- PIPartitionInstProv.enumInstance");
        }
        HscPerformance.endTransaction(n2, n);
        return vector;
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        System.out.println("========================PIPartitionInstProv.execQuery");
        return this.execQueryImpl(cIMObjectPath, string, n, cIMClass);
    }

    public Vector execQueryImpl(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        try {
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("****************************************\nPIPartitionInstProv.execQuery");
            }
            if (1 <= Trace.LEVEL) {
                Trace.trace("aplphscT", "-> PIPartitionInstProv.execQuery");
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace("aplphscF", "op = " + cIMObjectPath + "  query = " + string + "  q1 = " + n + "  cc = " + cIMClass);
            }
            Vector vector = this.m_InnerIProvider.execQuery(cIMObjectPath, string, n, cIMClass);
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("PIPartitionInstProv: end of execQuery\n****************************************");
            }
            Vector vector2 = vector;
            return vector2;
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
            throw new HSCCIMException(throwable);
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("aplphscT", "<- PIPartitionInstProv.execQuery");
            }
        }
    }

    public CIMInstance getInstanceImpl(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        CIMInstance cIMInstance;
        int n;
        int n2;
        block10: {
            n2 = HscPerformance.startTransaction("PIPartitionInstProv.getInstanceImpl+ " + cIMObjectPath);
            n = 0;
            try {
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("****************************************\nPIPartitionInstProv.getInstance");
                }
                if (1 <= Trace.LEVEL) {
                    Trace.trace("aplphscT", "-> PIPartitionInstProv.getInstance");
                }
                if (2 <= Trace.LEVEL) {
                    Trace.trace("aplphscF", "op = " + cIMObjectPath + "  cc = " + cIMClass + "  localOnly = " + bl);
                }
                CIMInstance cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)this.m_CimomHandle, cIMObjectPath, cIMClass, bl);
                if (2 <= Trace.LEVEL) {
                    Trace.trace("aplphscF", "returned instance = " + cIMInstance2);
                }
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("PIPartitionInstProv: end of getInstance\n****************************************");
                }
                cIMInstance = cIMInstance2;
                Object var9_9 = null;
                if (1 > Trace.LEVEL) break block10;
            }
            catch (Throwable throwable) {
                try {
                    n = 1;
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    throw new HSCCIMException(throwable);
                }
                catch (Throwable throwable2) {
                    Object var9_10 = null;
                    if (1 <= Trace.LEVEL) {
                        Trace.trace("aplphscT", "<- PIPartitionInstProv.getInstance");
                    }
                    HscPerformance.endTransaction(n2, n);
                    throw throwable2;
                }
            }
            Trace.trace("aplphscT", "<- PIPartitionInstProv.getInstance");
        }
        HscPerformance.endTransaction(n2, n);
        return cIMInstance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setInstanceImpl(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws PIHscServerException {
        int n = HscPerformance.startTransaction("PIPartitionInstProv.setInstanceImpl+ " + cIMObjectPath);
        int n2 = 0;
        System.out.println("In setInstance! .... ");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("****************************************\nPIPartitionInstProv.setInstance");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("aplphscT", "-> PIPartitionInstProv.setInstance");
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("aplphscF", "CIMObjectPath = " + cIMObjectPath + "  CIMInstantce ci =" + cIMInstance);
        }
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("========op = " + cIMObjectPath + "\n========ci = " + cIMInstance);
        }
        String string = "";
        String string2 = this.m_Namespace;
        String string3 = "";
        try {
            string3 = (String)cIMInstance.getProperty("Name").getValue().getValue();
        }
        catch (NullPointerException nullPointerException) {
            HscPerformance.endTransaction(n, 1);
            throw new PIHscServerException("2523", new String[]{"R50Partition.Name"}, nullPointerException);
        }
        int n3 = string3.indexOf(42);
        int n4 = Integer.parseInt(string3.substring(0, n3));
        String string4 = string3.substring(n3 + 1);
        OmCecMgr omCecMgr = OmCecMgr.getCecMgr(string4);
        int n5 = 64;
        FspLockHelper fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n5);
        try {
            try {
                UnsignedInt8 unsignedInt8;
                Vector vector;
                fspLockHelper.addNvramLock(omCecMgr.getObjectId());
                fspLockHelper.addLparLock(cIMObjectPath);
                fspLockHelper.lock();
                CIMClass cIMClass = new CIMClass(cIMObjectPath.getObjectName());
                CIMInstance cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)this.m_CimomHandle, cIMObjectPath, cIMClass, false);
                if (cIMInstance2 == null) {
                    n2 = 1;
                    throw new PIHscServerException("1586", new String[]{cIMObjectPath.toString()}, null);
                }
                if (2 <= Trace.LEVEL) {
                    Trace.trace("aplphscF", "original instance = " + cIMInstance2);
                }
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("oldInstance = " + cIMInstance2);
                }
                string = "";
                try {
                    string = (String)cIMInstance2.getProperty("UserDefinedName").getValue().getValue();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                UnsignedInt16 unsignedInt16 = new UnsignedInt16(Integer.parseInt(string3.substring(0, n3)));
                System.out.println("Partition ID: " + unsignedInt16);
                String string5 = "";
                try {
                    string5 = (String)cIMInstance.getProperty("UserDefinedName").getValue().getValue();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                PIPartitionInstProvUtils.validateLparName(string5);
                System.out.println("new user name = " + string5);
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_ComputerSystem", string2);
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                cIMObjectPath2.addKey("Name", new CIMValue((Object)string4));
                if (PIHscCimObjUtils.checkDupLparName((CIMOMHandle)this.m_CimomHandle, cIMObjectPath2, string5, unsignedInt16.intValue())) {
                    n2 = 1;
                    throw new PIHscServerException("05DE", new String[]{string5}, null);
                }
                CIMValue cIMValue = cIMInstance2.getProperty("SharedPoolUtilizationAuthority").getValue();
                UnsignedInt8 unsignedInt82 = new UnsignedInt8(0);
                if (cIMValue != null) {
                    unsignedInt82 = (UnsignedInt8)cIMValue.getValue();
                }
                cIMValue = cIMInstance.getProperty("SharedPoolUtilizationAuthority").getValue();
                UnsignedInt8 unsignedInt83 = new UnsignedInt8(0);
                if (cIMValue != null) {
                    unsignedInt83 = (UnsignedInt8)cIMValue.getValue();
                }
                CIMValue cIMValue2 = cIMInstance2.getProperty("HostingPartitions").getValue();
                Object[] objectArray = null;
                Object[] objectArray2 = null;
                if (cIMValue2 != null) {
                    vector = (Vector)cIMValue2.getValue();
                    objectArray2 = vector.toArray(new UnsignedInt16[0]);
                }
                if ((cIMValue2 = cIMInstance.getProperty("HostingPartitions").getValue()) != null) {
                    vector = (Vector)cIMValue2.getValue();
                    objectArray = vector.toArray(new UnsignedInt16[0]);
                }
                vector = cIMInstance2.getProperty("IPLSource").getValue();
                CIMValue cIMValue3 = cIMInstance.getProperty("IPLSource").getValue();
                UnsignedInt8 unsignedInt84 = null;
                UnsignedInt8 unsignedInt85 = null;
                if (vector != null) {
                    unsignedInt84 = (UnsignedInt8)vector.getValue();
                }
                if (cIMValue3 != null) {
                    unsignedInt85 = (UnsignedInt8)cIMValue3.getValue();
                }
                vector = cIMInstance2.getProperty("Keylock").getValue();
                cIMValue3 = cIMInstance.getProperty("Keylock").getValue();
                UnsignedInt8 unsignedInt86 = null;
                UnsignedInt8 unsignedInt87 = null;
                if (vector != null) {
                    unsignedInt86 = (UnsignedInt8)vector.getValue();
                }
                if (cIMValue3 != null) {
                    unsignedInt87 = (UnsignedInt8)cIMValue3.getValue();
                }
                vector = cIMInstance2.getProperty("PowerOnWithHypervisor").getValue();
                cIMValue3 = cIMInstance.getProperty("PowerOnWithHypervisor").getValue();
                UnsignedInt8 unsignedInt88 = null;
                UnsignedInt8 unsignedInt89 = null;
                if (vector != null) {
                    unsignedInt88 = (UnsignedInt8)vector.getValue();
                }
                if (cIMValue3 != null) {
                    unsignedInt89 = (UnsignedInt8)cIMValue3.getValue();
                }
                FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
                try {
                    unsignedInt8 = fspCmdHelper.getLparSlotDefinitionState(unsignedInt16);
                    if (2 <= Trace.LEVEL) {
                        Trace.trace("aplphscF", "curDefStateOnCec = " + unsignedInt8);
                    }
                    if (unsignedInt8.intValue() == 0) {
                        n2 = 1;
                        throw new PIHscServerException("05E0", new String[]{string}, null);
                    }
                    PIHMCSaveArea pIHMCSaveArea = PIHMCSaveArea.getPIHMCSaveAreaInstance(string4);
                    if (pIHMCSaveArea == null) {
                        n2 = 1;
                        throw new PIHscServerException("0005", null);
                    }
                    int n6 = unsignedInt8.intValue();
                    int n7 = 0;
                    if (n6 == 1 || n6 == 2) {
                        n7 = 1;
                    } else if (n6 == 129 || n6 == 130) {
                        n7 = 129;
                    } else if (n6 == 65 || n6 == 66) {
                        n7 = 4;
                    } else if (n6 == 3 || n6 == 4) {
                        n7 = 65;
                    }
                    pIHMCSaveArea.setPartitionInfo(unsignedInt16.intValue(), string5, (byte)n7);
                    if (string == null || !string.trim().equals(string5.trim())) {
                        fspCmdHelper.setLparName(unsignedInt16, string5);
                    }
                    FspVspAttr fspVspAttr = new FspVspAttr();
                    boolean bl = false;
                    if (unsignedInt8.intValue() == 129 || unsignedInt8.intValue() == 130) {
                        if (unsignedInt84 != unsignedInt85) {
                            fspVspAttr.setIplSource(unsignedInt85);
                            bl = true;
                        }
                        System.out.println("ci = " + cIMInstance);
                        System.out.println("oldInstance = " + cIMInstance2);
                        PIPartitionInstProvUtils.setTaggedIOData(cIMInstance2, cIMInstance, fspCmdHelper);
                    }
                    if (unsignedInt86 != unsignedInt87) {
                        fspVspAttr.setKeylock(unsignedInt87);
                        if (!bl) {
                            bl = true;
                        }
                    }
                    if (unsignedInt88 != unsignedInt89) {
                        fspVspAttr.setAutoIpl(unsignedInt89);
                        if (!bl) {
                            bl = true;
                        }
                    }
                    if (bl) {
                        fspCmdHelper.setLparVSPAttributes(unsignedInt16, fspVspAttr);
                    }
                    if (!unsignedInt82.equals((Object)unsignedInt83)) {
                        fspCmdHelper.setLparSharedPoolUtilizationAuthority(unsignedInt16, unsignedInt83);
                    }
                    if (!Arrays.equals(objectArray2, objectArray)) {
                        fspCmdHelper.setLparHostingPartitionIds(unsignedInt16, (UnsignedInt16[])objectArray);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("End of setInstance\n****************************************");
                    }
                    if (!(throwable instanceof PIHscServerException)) {
                        n2 = 1;
                        throw new PIHscServerException("05ED", new String[]{string}, throwable);
                    }
                    n2 = 1;
                    throw (PIHscServerException)throwable;
                }
                unsignedInt8 = PIPartitionInstProvUtils.getFilterNewInst(cIMInstance, cIMInstance2);
                try {
                    CimomWrapper.setInstance((CIMOMHandle)this.m_CimomHandle, cIMObjectPath, (CIMInstance)unsignedInt8);
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                }
                try {
                    omCecMgr.getIndMgr().sendIndication(4, cIMInstance, cIMInstance2);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                Object var42_48 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                n2 = 1;
                if (throwable instanceof PIHscServerException) throw (PIHscServerException)throwable;
                throw new PIHscServerException("05ED", new String[]{string}, throwable);
            }
        }
        catch (Throwable throwable) {
            Object var42_49 = null;
            fspLockHelper.unlock();
            if (1 <= Trace.LEVEL) {
                Trace.trace("aplphscT", "<- PIPartitionInstProv.setInstance");
            }
            HscPerformance.endTransaction(n, n2);
            throw throwable;
        }
        fspLockHelper.unlock();
        if (1 <= Trace.LEVEL) {
            Trace.trace("aplphscT", "<- PIPartitionInstProv.setInstance");
        }
        HscPerformance.endTransaction(n, n2);
    }

    public String getCecName(CIMObjectPath cIMObjectPath) throws CIMException {
        CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.m_CimomHandle, cIMObjectPath, this.m_CimomHandle.getClass(cIMObjectPath, false), false);
        String string = (String)cIMInstance.getProperty("Name").getValue().getValue();
        string = string.trim();
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("partitionName = " + string);
        }
        int n = string.indexOf(42);
        String string2 = string.substring(n + 1);
        if (2 <= Trace.LEVEL) {
            Trace.trace("aplphscF", "cecName = " + string2);
        }
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("cecName = " + string2);
        }
        return string2;
    }

    public static String getCecNameFromKeys(CIMObjectPath cIMObjectPath) throws CIMException {
        CIMProperty cIMProperty = null;
        String string = null;
        Vector vector = cIMObjectPath.getKeys();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            cIMProperty = (CIMProperty)vector.elementAt(i);
            if (!cIMProperty.getName().equals("Name")) continue;
            string = (String)cIMProperty.getValue().getValue();
            break;
        }
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("In PIPartitionInstProv.getCecName(). cecName = " + string);
        }
        return string;
    }
}

